 ; Ŀ
 ;   SdkOut - extract data from an sdk into a csv.                         
 ;   Copyright 1998 by Rocket Software                                     
 ;                                                                         
 ; 

 ; Ŀ
 ;   Grist - make the ((tagname value)...) list.                           
 ;   Takes one argument, the block insert ename.                           
 ;   Returns a list: the list of lists, the highest lead character or      
 ;   characters in a tag name, the lowest lead character(s), the highest   
 ;   ending number and the lowest ending number.                           
 ; 
 (DEFUN GRIST (enam / tagg vall chlist attlst num hinum lonum hichar lochar)
  (setq num 0)
  (setq lonum 1000)
  (setq lochar "ZZZZZ")
  (setq hinum 0)
  (setq hichar "A")
  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                              (setq enam (entnext enam)))))))
         (grtext -2 (itoa (setq num (1+ num))))
         (setq tagg (cdr (assoc 2 entt)))
         (setq vall (cdr (assoc 1 entt)))
         (setq chlist (monster tagg))
         (setq cnum (read (cadr chlist)))
         (setq cchar (car chlist))
         (setq hinum (max hinum cnum))
         (setq lonum (min lonum cnum))
         (cond ((> (strlen cchar) (strlen hichar))
                (setq hichar cchar))
               ((and (= (strlen cchar) (strlen hichar))
                     (/= (car (acad_strlsort (list cchar hichar))) cchar))
                (setq hichar cchar)))
         (cond ((< (strlen cchar) (strlen lochar))
                (setq lochar cchar))
               ((and (= (strlen cchar) (strlen lochar))
                     (= (car (acad_strlsort (list lochar cchar))) cchar))
                (setq lochar cchar)))
         (setq attlst (append attlst (list (list tagg vall)))))
 (list attlst hinum lonum hichar lochar))
 ; Ŀ
 ;   Grist end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Alph - increment a character string.                       
 ;   Copyright 1996 by Rocket Software                                     
 ;   Takes one argument, a string.  Returns the incremented version.       
 ; 
 (DEFUN ALPH (cname /)
  (setq pos (strlen cname))
  (while (and (>= pos 1)
              (setq char (substr cname pos 1))
              (<= 90 (ascii char)))
         (setq pos (1- pos)))
 ; Ŀ
 ;   If no non-z characters were found, set all to A and add an A to the   
 ;   left end of the string.                                               
 ; 
  (cond ((= pos 0)
         (setq base "")
         (repeat (1+ (strlen cname))
                 (setq base (strcat base "A")))
         (setq cname base))
 ; Ŀ
 ;   If a non-Z was found, everything to the right of it becomes an A,     
 ;   and it is incremented.                                                
 ; 
        (T (setq cnamp cname)
           (setq cname (strcat (substr cname 1 (1- pos))
                               (chr (1+ (ascii (substr cname pos 1))))))
           (setq base "")
           (repeat (strlen (substr cnamp (1+ pos)))
                   (setq base (strcat base "A")))
           (setq cname (strcat cname base))))
 cname)
 ; Ŀ
 ;   Alph end.                                                             
 ; 

 ; Ŀ
 ;   Monster - Separate a text string into numbers and letters.            
 ;   Copyright 1992  Rocket Software                                       
 ;   This function returns a list of strings, alternating between numbers  
 ;   and letters.  The first string is always a character string - if the  
 ;   first character is a number then the first string will be empty       
 ;   (""). A period (.) will be interpreted as being the same type as the  
 ;   preceding character.                                                  
 ; 
 (DEFUN MONSTER (string / chastr pre ascnum posi this asc last strlist)
  (setq chastr "")
  (setq pre "c")
  (setq ascnum (list 48 49 50 51 52 53 54 55 56 57))
  (setq posi 1)
  (while (/= "" (setq this (substr string posi 1)))
       (setq asc (ascii this))
       (cond ((member asc ascnum)         ; if char is a number
              (setq last "n"))
             ((= asc 46)                  ; if char is a .
              (if (= last "c")
                  (setq last "c")
                  (setq last "n")))
             (T                           ; otherwise it must be a letter
               (setq last "c")))
 ; Ŀ
 ;   If pre = last then strcat "this" onto chastr.                         
 ;   If not then append chastr onto strlist and set chastr to this.        
 ; 
       (if (equal pre last)
           (setq chastr (strcat chastr this))
           (progn
                (if strlist
                   (setq strlist (append strlist (list chastr)))
                   (setq strlist (list chastr)))
                (setq chastr this)))
       (setq pre last)
       (setq posi (1+ posi)))
  (if chastr (setq strlist (append strlist (list chastr))))
 strlist)
 ; Ŀ
 ;   Monster end.                                                          
 ; 

 ; Ŀ
 ;   Mint - Convert seconds to hours, minutes and seconds.                 
 ;   Takes an integer argument, returns a string.                          
 ; 
 (DEFUN MINT (sec / hours mins)
  (setq hours (itoa (fix (/ sec 3600))))
  (setq sec (rem sec 3600))
  (setq mins (itoa (fix (/ sec 60))))
  (setq sec (itoa (fix (rem sec 60))))
  (if (= (strlen hours) 1) (setq hours (strcat "0" hours)))
  (if (= (strlen mins) 1) (setq mins (strcat "0" mins)))
  (if (= (strlen sec) 1) (setq sec (strcat "0" sec)))
  (strcat hours ":" mins ":" sec))
 ; Ŀ
 ;   Mint end.                                                             
 ; 

 ; Ŀ
 ;   Nopath - returns the drawing name without the path.                   
 ; 
 (DEFUN NOPATH ( / tt pos ff)
 ; Ŀ
 ;   Get drawing name with path and set pointer Pos to end of string.      
 ; 
  (setq pos (strlen (setq tt (getvar "dwgname"))))  ; start at end of string
 ; Ŀ
 ;   Remove path.                                                          
 ; 
  (while (< 0 pos)
          (if (or (= (substr tt pos 1) (chr 92))    ; if char = \
                  (= (substr tt pos 1) ":"))        ; if char = :
             (progn
                   (setq tt (substr tt (1+ pos)))   ; then set tt to all after
                   (setq pos 1)))                   ;  and set pos to first
         (setq pos (1- pos)))                       ; set pos to previous
  tt)
 ; Ŀ
 ;   Nopath end.                                                           
 ; 

 ; Ŀ
 ;   SdkOut.                                                               
 ; 
 (DEFUN C:SDKOUT (/ ss s t1 enam)
 ; Ŀ
 ;   Make a filename.                                                      
 ; 
  (setq filnam (strcat (nopath) ".csv"))
 ; Ŀ
 ;   Start the timer.                                                      
 ; 
  (setq s (getvar "date"))
  (setq t1 (* 86400.0 (- s (fix s))))                ; start time for timer
 ; Ŀ
 ;   Find the Sdk block.                                                   
 ; 
  (if (or (setq ss (ssget "X" (list (cons 2 "OUT1IN1"))))
          (setq ss (ssget "X" (list (cons 2 "OUT2IN1"))))
          (setq ss (ssget "X" (list (cons 2 "OUT1IN2"))))
          (setq ss (ssget "X" (list (cons 2 "OUT2IN2"))))
          (setq ss (ssget "X" (list (cons 2 "OUT3IN1"))))
          (setq ss (ssget "X" (list (cons 2 "OUT3IN2")))))
      (progn
 ; Ŀ
 ;   Suck the contents of the block into a list of lists: (tag value)...   
 ; 
           (setq enam (ssname ss 0))
           (setq attlst (grist enam))
           (setq hinum (nth 1 attlst))
           (setq lonum (nth 2 attlst))
           (setq hichar (nth 3 attlst))
           (setq lochar (nth 4 attlst))
           (setq attlst (car attlst))
 ; Ŀ
 ;   Now sort the list into rows and columns.                              
 ;   Make the initial tag name (the upper left corner cell name) and       
 ;   put the matching value into a string, followed by a comma.            
 ;   Repeat, incrementing the alphabetic portion each time until it        
 ;   equals the highest string, then write the line to a file, and start   
 ;   again with the next number and the original character string.         
 ;   Repeat until the highest number has been used.                        
 ; 
           (setq cdfstr "")
           (setq cchar lochar)
           (setq cnum lonum)
           (while (null stop)
                  (setq ccell (strcat cchar (itoa cnum)))
                  (grtext -2 ccell)
                  (if (setq cvar (assoc ccell attlst))
                      (if (= cdfstr "")
                          (setq cdfstr (cadr cvar))
                          (setq cdfstr (strcat cdfstr "," (cadr cvar)))))
                  (setq cchar (alph cchar))
                  (if (= cchar hichar)
                      (progn
                           (setq fn (open filnam "a"))
                           (write-line cdfstr fn)
                           (close fn)
                           (setq cdfstr "")
                           (setq cchar lochar)
                           (if (= cnum hinum)
                               (setq stop t)
                               (setq cnum (1+ cnum))))))))
 ; Ŀ
 ;   Calculate and print elapsed time.                                     
 ; 
  (setq s (getvar "date"))
  (setq t2 (* 86400.0 (- s (fix s))))
  (prompt (strcat "\nElapsed time: " (mint (- t2 t1)) "."))
 (princ))